<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="COCT_MT090000NL2" see="http://wiki.hl7.org/index.php?title=Implementatiehandleiding_HL7v3_basiscomponenten_v2.2_Part3#CMET_R_AssignedPersonUniversal">
    <title>R_AssignedEntityNL_PO universal</title>
    <rule context="$element">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ASSIGNED"
            >COCT_MT090000NL2: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
    </rule>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:certificateText">
        <extends rule="ED"/>
    </rule>
    
    <rule context="$element/hl7:assignedOrganization/hl7:name">
        <extends rule="ON"/>
    </rule>
    
    <rule context="$element/hl7:assignedPerson/hl7:name">
        <extends rule="PN"/>
    </rule>
    
    <rule context="$element/hl7:Organization/hl7:id | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:id | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:code | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:code | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:name | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:name | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:name">
        <extends rule="ON"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:desc | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:desc | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:desc">
        <extends rule="ST"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:statusCode | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:statusCode | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:telecom | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:telecom | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:addr | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:addr | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:standardIndustryClassCode | $element/hl7:Organization//hl7:part/hl7:partOrganization/hl7:standardIndustryClassCode | $element/hl7:Organization//hl7:part-of/hl7:wholeOrganization/hl7:standardIndustryClassCode">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:Organization//hl7:contact/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:Organization//hl7:contact/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:Organization//hl7:contact/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:Organization//hl7:contact/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:Organization//hl7:contact/hl7:contactPerson/hl7:name">
        <extends rule="PN"/>
    </rule>
    <!-- TODO: LocatedEntity, but unlikely someone would use that ... -->
</pattern>